| package |
package := Package name: 'AIDA support'.
package paxVersion: 1;
	basicComment: ''.


package classNames
	add: #AIDARoot;
	add: #DailyCollection;
	add: #DailyValues;
	add: #History;
	add: #HtmlRender;
	add: #Numberer;
	add: #RDBTable;
	add: #VersionedObject;
	add: #VersionSpec;
	add: #WikiLink;
	add: #WikiRender;
	yourself.

package binaryGlobalNames: (Set new
	yourself).

package globalAliases: (Set new
	yourself).

package setPrerequisites: (IdentitySet new
	add: '..\Object Arts\Dolphin\Base\Dolphin';
	add: '..\Object Arts\Dolphin\MVP\Base\Dolphin MVP Base';
	yourself).

package!

"Class Definitions"!

Object subclass: #AIDARoot
	instanceVariableNames: ''
	classVariableNames: 'Lock Root'
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #DailyCollection
	instanceVariableNames: 'days'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #DailyValues
	instanceVariableNames: 'days'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #History
	instanceVariableNames: 'dates values changedDates authors comments historyCollection'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #HtmlRender
	instanceVariableNames: 'inputStream outputStream'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #Numberer
	instanceVariableNames: 'counters'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #RDBTable
	instanceVariableNames: 'environment username password codepage table columns records'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #VersionedObject
	instanceVariableNames: 'version'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #VersionSpec
	instanceVariableNames: 'object number current parent next'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #WikiLink
	instanceVariableNames: 'address name siblingReference isMethod fragment'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
HtmlRender subclass: #WikiRender
	instanceVariableNames: 'mode currentChar lastChar headingLevel inTable bulletLevel numberLevel inBold'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!

"Global Aliases"!


"Loose Methods"!

"End of package definition"!

"Source Globals"!

"Classes"!

AIDARoot guid: (GUID fromString: '{25239132-23E4-4884-B904-80C81788F842}')!
AIDARoot comment: ''!
!AIDARoot categoriesForClass!Unclassified! !
!AIDARoot class methodsFor!

critical: aBlock
	"For protecting critical sections in parallel execution of web requests. Use it always
	when you do things, which cannot be disturbed by another request. Example:
		WebTransactionMonitor critical: [<a block with critical section>]. "

	^self localCritical: aBlock
"
	self inGemstone
		ifTrue: [GBSM currentSession critical: aBlock]
		ifFalse: [self localCritical: aBlock]
"!

inGemstone
	^self persistenceType = #gemstone!

initialize
!

initLock
	Lock := RecursionLock new.!

initRoot
	(self isPersistent and: [self isLoggedIn not]) ifTrue:
		[^self error: 'you are not logged in!!'].
	Root := self newRootObject.!

inVersant
	^self persistenceType = #versant!

isLoggedIn
	self inGemstone ifTrue: [^self isGemstoneLoggedIn].
	self inVersant ifTrue: [^self isVersantLoggedIn].
	^false!

isPersistent
	^self persistenceType ~= #none!

localCritical: aBlock
	"For protecting critical sections in parallel execution of web requests. Use it always
	when you do things, which cannot be disturbed by another request. Example:
		WebTransactionMonitor critical: [<a block with critical section>]. "

	^self lock critical: aBlock!

lock
	Lock isNil ifTrue: [self initLock].
	^Lock!

login
	self inGemstone ifTrue: [^self openGemstoneDatabase].
	self inVersant ifTrue: [^self openVersantDatabase].

"AAIDARoot login"!

logout
	self inGemstone ifTrue: [^self closeGemstoneDatabase].
	self inVersant ifTrue: [^self closeVersantDatabase].

"AAIDARoot logout"!

newRoot: anObject named: aSymbol

	| createAnyway |
	(self root includesKey: aSymbol) ifTrue: 
		[createAnyway := Dialog confirm: 'Root named ', 
			aSymbol asString, ' already exist!! Do you realy want to replace it?'.
		createAnyway ifFalse: [^nil] ].
	self root at: aSymbol put: anObject.
	self inGemstone ifTrue: [GBSM currentSession commitTransaction]!

newRootObject
	^Dictionary new!

persistenceType
	"Type of a database you use. It can be
		#none: no database, all objects in an image
		#gemstone: in a Gemstone database,
		#versant: in a Versant database.
	Default is #none"

	^#none
	"^#gemstone"

"AIDARoot persistenceType"!

removeRootNamed: aSymbol
	| realyRemove |
	(self root includesKey: aSymbol) ifTrue: 
		[realyRemove := Dialog confirm: 'Do you realy want to remove a root named ', 
			aSymbol asString, ' ?'.
		realyRemove ifFalse: [^nil] ].
	self root removeKey: aSymbol ifAbsent: [].!

root
	Root isNil ifTrue: [self initRoot].
	^Root!

rootKey
	^#AIDARoot! !
!AIDARoot class categoriesFor: #critical:!critical sections!private! !
!AIDARoot class categoriesFor: #inGemstone!odb testing!private! !
!AIDARoot class categoriesFor: #initialize!initialize - release!private! !
!AIDARoot class categoriesFor: #initLock!private! !
!AIDARoot class categoriesFor: #initRoot!private! !
!AIDARoot class categoriesFor: #inVersant!odb testing!private! !
!AIDARoot class categoriesFor: #isLoggedIn!odb testing!private! !
!AIDARoot class categoriesFor: #isPersistent!odb testing!private! !
!AIDARoot class categoriesFor: #localCritical:!critical sections!private! !
!AIDARoot class categoriesFor: #lock!private! !
!AIDARoot class categoriesFor: #login!odb login/logout!private! !
!AIDARoot class categoriesFor: #logout!odb login/logout!private! !
!AIDARoot class categoriesFor: #newRoot:named:!private! !
!AIDARoot class categoriesFor: #newRootObject!private! !
!AIDARoot class categoriesFor: #persistenceType!odb setup!private! !
!AIDARoot class categoriesFor: #removeRootNamed:!private! !
!AIDARoot class categoriesFor: #root!private! !
!AIDARoot class categoriesFor: #rootKey!private!private - gemstone! !

DailyCollection guid: (GUID fromString: '{7832A620-ACE8-444C-A876-B359174970E7}')!
DailyCollection comment: ''!
!DailyCollection categoriesForClass!Unclassified! !
!DailyCollection methodsFor!

add: newObject

	self add: newObject onDate: newObject date!

add: newObject onDate: aDate
	(self includes: newObject onDate: aDate) ifTrue: [^nil].
	self existCheckDate: aDate.
	(self days at: aDate asDays) add: newObject.
	^newObject!

addAll: aCollection 

	aCollection do: [:each | self add: each].
	^aCollection!

addAll: aCollection onDate: aDate

	self existCheckDate: aDate.
	^aCollection do: [:each | 	self add: each onDate: aDate].!

addFirst: newObject inYear: aYear
	"put in first place at 1st jan of this year"
	| date |
	date := Date newDay: 1 monthNumber: 1 year: aYear.
	(self includes: newObject onDate: date) ifTrue: [^nil].
	self existCheckDate: date.
	(self days at: date asDays) addFirst: newObject.
	^newObject!

addLast: newObject inYear: aYear
	"put in first place at 1st jan of this year"
	| date |
	date := Date newDay: 31 monthNumber: 12 year: aYear.
	(self includes: newObject onDate: date) ifTrue: [^nil].
	self existCheckDate: date.
	(self days at: date asDays) addLast: newObject.
	^newObject!

all
	| dayCol |
	dayCol := SortedCollection
		withAll: self days keys
		sortBlock: [:a :b | a > b].
	^dayCol inject: OrderedCollection new into: [:col :each | col addAll: (self days at: each); yourself ].!

allDated: aDate

	^(self days at: aDate asDays ifAbsent: [^#()] ) copy!

allDates
	"all dates on which something exist"
	^self allDays collect: [:each | Date fromDays: each]!

allDays
	"all day numbers on which something exist"
	^self days keys!

allDaysForKindOf: aClass
	"all day numbers on which something of that class exist"
	^self days keys select: [:day | 
		(self days at: day) contains: [:each | each isKindOf: aClass] ].!

allFromDate: aStartDate to: anEndDate
	| startDay endDay daysInRange |
	startDay := aStartDate asDays. endDay := anEndDate asDays.
	daysInRange := self allDays select: [:each | each >= startDay and: [each <= endDay] ].
	daysInRange := daysInRange asSortedCollection. 
	^daysInRange inject: OrderedCollection new into: [:col :each | col addAll: (self days at: each). col]

"DailyCollection allInstances last allFromDate: (Date readSloFrom: '1.1.2004' readStream) 
  	to: (Date readSloFrom: '31.12.2006' readStream)"!

allLastMonth
	^self allMonthly: Date today - Date today day!

allLastWeek
	^self allWeekly: Date today - 7!

allLastYear
	^self allYear: Date today year - 1!

allMonthly: aDate
	^self 
		allFromDate: aDate firstDayOfMonth
		to: aDate firstDayInMonth + aDate daysInMonth - 1!

allSinceDate: aDate
	^self allFromDate: aDate to: Date today!

allThisMonth
	^self allMonthly: Date today!

allThisWeek
	^self allWeekly: Date today!

allThisYear
	^self allYear: Date today year!

allToday
	^self allDated: Date today!

allWeekly: aDate
	^self 
		allFromDate: aDate - aDate weekdayIndex + 1
		to: aDate - aDate weekdayIndex + 1 + 7!

allYear: aNumber
	^self 
		allFromDate: (Date newDay: 1 monthNumber: 1 year: aNumber)
		to: (Date newDay: 31 monthNumber: 12 year: aNumber)!

allYears
	"all years on which something exist"
	^SortedCollection 
		withAll: (self allDates inject: Set new into: [:set :each | set add: each year. set])
		sortBlock: [:a :b | a < b]

"DailyCollection allInstances last allYears"!

allYearsForKindOf: aClass
	"all years on which something of that class exist"
	| allDays currentYear years skipToDay |
	allDays := self days keys asSortedCollection. allDays isEmpty ifTrue: [^#()].
	currentYear := (Date fromDays: allDays first) year.
	years := Set new. skipToDay := 0.
	allDays do: [:day |
		day >= skipToDay ifTrue:
			[((self days at: day) contains: [:entry | entry isKindOf: aClass]) ifTrue:
				[years add: currentYear. currentYear := currentYear + 1.
				skipToDay := (Date newDay: 1 monthNumber: 1 year: currentYear) asDays] ] ].
	^years asSortedCollection

"DailyCollection allInstances last allYearsForKindOf: AIDA.Invoice "!

allYesterday
	^self allDated: Date today - 1!

contains: aBlock 
	"Evaluate aBlock with each of the receiver's elements as the argument. 
	Answer true if aBlock ever evaluates to true, otherwise answer false."

	self detect: aBlock ifNone: [^false].
	^true!

days
	days isNil ifTrue: [self initDays].
	^days!

existCheckDate: aDate

	(self days includesKey: aDate asDays) ifFalse:
		[self days at: aDate asDays put: OrderedCollection new].!

firstInYear: aYear
	"on 1st january of that year"
	| col |
	col := self allDated: (Date newDay: 1 monthNumber: 1 year: aYear).
	col isEmpty ifTrue: [^nil].
	^col first!

includes: anObject
	"Answer whether anObject is one of the receiver's elements."

	self days values do: [:each | (each includes: anObject) ifTrue: [^true]].
	^false!

includes: anObject onDate: aDate
	| values |
	values := self days at: aDate asDays ifAbsent: [^false].
	^values includes: anObject!

initDays
	days := Dictionary new.!

isEmpty
	"Answer whether the receiver contains any elements."

	^self size = 0!

last: aNumber
	"find last number of values, starting from today and back in past. Most recent first!!"
	| collection dayColl |
	collection := OrderedCollection new.
	dayColl := SortedCollection withAll: self days keys sortBlock: [:a :b | a > b].
	dayColl do: [:day || coll |
		coll := (self days at: day) copy reverse.
		collection addAll: (coll copyFrom: 1 to: ((aNumber - collection size) min: coll size) ).
		collection size = aNumber ifTrue: [^collection] ].
	^collection

"LogisticSystem default owner events size last: 1000"!

lastDayInYear: aYear
	"on 31 december of that year"
	^self allDated: (Date newDay: 31 monthNumber: 12 year: aYear).!

remove: oldObject 
	^self remove: oldObject ifAbsent: [self notFoundError]!

remove: oldObject ifAbsent: anExceptionBlock
	| collection |
	collection := self days at: oldObject date asDays ifAbsent: [^anExceptionBlock value].
	collection remove: oldObject ifAbsent: [^anExceptionBlock value].!

removeAll: aCollection 
	"Remove each element of aCollection from the receiver.  If successful for each,
	answer aCollection."
	aCollection do: [:each | self remove: each].
	^aCollection!

size
	days isNil ifTrue: [^0].
	^self days values inject: 0 into: [:sum :each | sum + each size].! !
!DailyCollection categoriesFor: #add:!adding - removing!private! !
!DailyCollection categoriesFor: #add:onDate:!adding - removing!private! !
!DailyCollection categoriesFor: #addAll:!adding - removing!private! !
!DailyCollection categoriesFor: #addAll:onDate:!adding - removing!private! !
!DailyCollection categoriesFor: #addFirst:inYear:!adding - removing!private! !
!DailyCollection categoriesFor: #addLast:inYear:!adding - removing!private! !
!DailyCollection categoriesFor: #all!private!private-accessing! !
!DailyCollection categoriesFor: #allDated:!accessing!private! !
!DailyCollection categoriesFor: #allDates!accessing!private! !
!DailyCollection categoriesFor: #allDays!private!private-accessing! !
!DailyCollection categoriesFor: #allDaysForKindOf:!private!private-accessing! !
!DailyCollection categoriesFor: #allFromDate:to:!accessing!private! !
!DailyCollection categoriesFor: #allLastMonth!accessing!private! !
!DailyCollection categoriesFor: #allLastWeek!accessing!private! !
!DailyCollection categoriesFor: #allLastYear!accessing!private! !
!DailyCollection categoriesFor: #allMonthly:!accessing!private! !
!DailyCollection categoriesFor: #allSinceDate:!accessing!private! !
!DailyCollection categoriesFor: #allThisMonth!accessing!private! !
!DailyCollection categoriesFor: #allThisWeek!accessing!private! !
!DailyCollection categoriesFor: #allThisYear!accessing!private! !
!DailyCollection categoriesFor: #allToday!accessing!private! !
!DailyCollection categoriesFor: #allWeekly:!accessing!private! !
!DailyCollection categoriesFor: #allYear:!accessing!private! !
!DailyCollection categoriesFor: #allYears!accessing!private! !
!DailyCollection categoriesFor: #allYearsForKindOf:!private!private-accessing! !
!DailyCollection categoriesFor: #allYesterday!accessing!private! !
!DailyCollection categoriesFor: #contains:!private!testing! !
!DailyCollection categoriesFor: #days!private! !
!DailyCollection categoriesFor: #existCheckDate:!private! !
!DailyCollection categoriesFor: #firstInYear:!accessing!private! !
!DailyCollection categoriesFor: #includes:!private!testing! !
!DailyCollection categoriesFor: #includes:onDate:!private!testing! !
!DailyCollection categoriesFor: #initDays!private! !
!DailyCollection categoriesFor: #isEmpty!private!testing! !
!DailyCollection categoriesFor: #last:!accessing!private! !
!DailyCollection categoriesFor: #lastDayInYear:!accessing!private! !
!DailyCollection categoriesFor: #remove:!adding - removing!private! !
!DailyCollection categoriesFor: #remove:ifAbsent:!adding - removing!private! !
!DailyCollection categoriesFor: #removeAll:!adding - removing!private! !
!DailyCollection categoriesFor: #size!accessing!private! !

DailyValues guid: (GUID fromString: '{94184092-E6F8-4DF6-8A72-8E1DA968C483}')!
DailyValues comment: ''!
!DailyValues categoriesForClass!Unclassified! !
!DailyValues methodsFor!

allDates
	"all dates on which something exist"
	^self days keys collect: [:each | Date fromDays: each]!

allFromDate: aStartDate to: anEndDate

	| collection |
	collection := OrderedCollection new: 100.
	aStartDate to: anEndDate do: [:date |
		collection add: (self at: date) ].
	^collection!

allLastMonth
	^self allMonthly: Date today - Date today day!

allLastWeek
	^self allWeekly: Date today - 7!

allMonthly: aDate
	^self 
		allFromDate: aDate firstDayOfMonth
		to: aDate firstDayInMonth + aDate daysInMonth - 1!

allThisMonth
	^self allMonthly: Date today!

allThisWeek
	^self allWeekly: Date today!

allWeekly: aDate
	^self 
		allFromDate: aDate - aDate weekdayIndex + 1
		to: aDate - aDate weekdayIndex + 1 + 7!

at: aDate
	^self days at: aDate asDays ifAbsent: [self defaultValue]!

at: aDate add: aValue 
	self existCheckDate: aDate.
	^self days at: aDate asDays put: (self at: aDate) + aValue!

at: aDate put: aValue
	self existCheckDate: aDate.
	^self days at: aDate asDays put: aValue!

at: aDate subtract: aValue
	self existCheckDate: aDate.
	^self days at: aDate asDays put: (self at: aDate) - aValue!

days
	days isNil ifTrue: [self initDays].
	^days!

defaultValue
	^0!

existCheckDate: aDate

	(self days includesKey: aDate asDays) ifFalse:
		[self days at: aDate asDays put: self defaultValue].!

initDays
	days := IdentityDictionary new.!

isEmpty
	"Answer whether the receiver contains any elements."

	^self size = 0!

last: aNumber
	"find last number of values, starting from today and back in past. Most recent first!!"
	| collection |
	collection := OrderedCollection new.
	1 to: aNumber do: [:inx | collection add: (self at: Date today - inx + 1)].
	^collection!

resetAt: aDate
	"put default value at this date"
	^self at: aDate put: self defaultValue!

size
	^self days values size!

sumFromDate: aStartDate to: anEndDate

	^(self allFromDate: aStartDate to: anEndDate)
		inject: 0
		into: [:sum :each | sum + each]!

sumLast: aNumber
	"sum values of aNumber of days, starting from today and back"

	^(self last: aNumber)
		inject: 0
		into: [:sum :each | sum + each]!

sumMonthly: aDate

	^(self allMonthly: aDate)
		inject: 0
		into: [:sum :each | sum + each]!

sumWeekly: aDate

	^(self allWeekly: aDate)
		inject: 0
		into: [:sum :each | sum + each]! !
!DailyValues categoriesFor: #allDates!accessing!private! !
!DailyValues categoriesFor: #allFromDate:to:!accessing!private! !
!DailyValues categoriesFor: #allLastMonth!accessing!private! !
!DailyValues categoriesFor: #allLastWeek!accessing!private! !
!DailyValues categoriesFor: #allMonthly:!accessing!private! !
!DailyValues categoriesFor: #allThisMonth!accessing!private! !
!DailyValues categoriesFor: #allThisWeek!accessing!private! !
!DailyValues categoriesFor: #allWeekly:!accessing!private! !
!DailyValues categoriesFor: #at:!adding - removing!private! !
!DailyValues categoriesFor: #at:add:!adding - removing!private! !
!DailyValues categoriesFor: #at:put:!adding - removing!private! !
!DailyValues categoriesFor: #at:subtract:!adding - removing!private! !
!DailyValues categoriesFor: #days!private! !
!DailyValues categoriesFor: #defaultValue!private! !
!DailyValues categoriesFor: #existCheckDate:!private! !
!DailyValues categoriesFor: #initDays!private! !
!DailyValues categoriesFor: #isEmpty!private!testing! !
!DailyValues categoriesFor: #last:!accessing!private! !
!DailyValues categoriesFor: #resetAt:!adding - removing!private! !
!DailyValues categoriesFor: #size!accessing!private! !
!DailyValues categoriesFor: #sumFromDate:to:!accessing!private! !
!DailyValues categoriesFor: #sumLast:!accessing!private! !
!DailyValues categoriesFor: #sumMonthly:!accessing!private! !
!DailyValues categoriesFor: #sumWeekly:!accessing!private! !

History guid: (GUID fromString: '{E0037072-EAC6-4CE9-B3A6-031FA5D86DF5}')!
History comment: ''!
!History categoriesForClass!Unclassified! !
!History methodsFor!

activeFromArray: anArray

	"return a active flag from entries in history array"

	^anArray at: 5!

addValue: aValue dated: aDate author: aString comment: aCommentString
	"adds data, which is newer than any existing one"
	self dates add: aDate asDays.
	self values add: aValue.
	self changedDates add: Date today asDays.
	self authors add: aString.
	self comments add: aString.!

arrayWithDate: aDate time: aTime value: aValue active: aBoolean

	"return a array with argument vaules for entry to history collection"

	| array |
	array := Array new: 5.
	array 
		at: 1 put: aDate year;
		at: 2 put: aDate day;
		at: 3 put: (aTime notNil ifTrue: [aTime asSeconds] ifFalse: [0]);
		at: 4 put: aValue;
		at: 5 put: aBoolean.
	^array!

authors
	" a collection of authors, which made changes, (as a String or reference to a WebUser)"
	^authors!

changedDates
	" a collection of dates, when value was changed in asDays format"
	^changedDates!

changeValue: aValue author: aString comment: aCommentString onIndex: anIndexNumber
	"change data in a specificied index"
	self values at: anIndexNumber put: aValue.
	self changedDates at: anIndexNumber put: Date today asDays.
	self authors at: anIndexNumber put: aString.
	self comments at: anIndexNumber put: aString.!

comments
	" a collection of comments about changes"
	^comments!

dateFromArray: anArray

	"return a date from entries in history array"

	^Date
		newDay: (anArray at: 2)
		year: (anArray at: 1)!

dates
	" a collection of dates of changes in asDays format"
	^dates!

hasDuplicateDates

	"maintenance - check if more than one entry with the same date exist"

	| unique |
	unique := Set new.
	self dates do: [: date | (unique includes: date)
		ifTrue: [^true]
		ifFalse: [unique add: date] ].
	^false!

historyCollection
	"this is an ordered collection of array with year, day in year, time, value, active flag. 
	Collection is ordered from oldest to newest version of value. Active flag is used to 
	'delete' some version from history, but you can still have a trace, who/when some 
	change occured.

	3.11.98 NOT USED anymore. Here just for migration!!"


	historyCollection isNil ifTrue: [self initHistoryCollection].
	^historyCollection!

historyOfChanges

	"return a history of all changes of value. It is returned as ordered collection of collections, each with:
	valid from date
	valid to date (for last change: nil)
	new value
	date of change
	author of change
	comment of change	

Returned collection has the oldest change (by valied from date) as first, the newest as last. "!

indexForDate: aDate

	"return index of entry in dates collection, which fits most to the specified date. If no direct 
	entry on a specified date exist, then entry for previous date is used. If aDate is older than
	any date in collection, nil is returned!!"


	| first last days mdays index |

	first := 1. last := self dates size.
	last = 0 ifTrue: [^nil].
	days := aDate asDays.
	days >= self dates last ifTrue: [^last].
	days < self dates first ifTrue: [^nil].
	[last >= first] whileTrue: 	
		[ "(first = last and: [days = (self dates at: first)]) ifTrue: [^first].  " " not needed!! "
		index := (first + last) // 2.
		mdays := self dates at: index.
		days = mdays ifTrue: [^index].
		days < mdays
			ifTrue: [last := index - 1.]
			ifFalse: [first := index + 1.]].
"2.11.98 Sivec prej :
		^1 max: index - 1.
"
	index := (first + last) // 2.
	^1 max: index.




"
| h |
h := History new.
h dates
	add: (Date today) asDays;
	add: (Date today + 1) asDays;
	add: (Date today + 3) asDays;
	add: (Date today + 4) asDays.
Transcript cr;show: (h indexForDate: Date today - 1) printString.
Transcript cr;show: (h indexForDate: Date today + 1) printString.
Transcript cr;show: (h indexForDate: Date today + 2) printString.
Transcript cr;show: (h indexForDate: Date today + 3) printString.
h inspect.
"





"
	self historyCollection keysAndValuesDo: [:index :array |
		(self activeFromArray: array) 
			ifTrue:
				[(self dateFromArray: array) < (aDate + 1)
					ifTrue: [prevIndex := index]
					ifFalse: [^prevIndex]	] ].
	^prevIndex
"!

initAuthors
	authors := OrderedCollection new.!

initChangedDates
	changedDates := OrderedCollection new.!

initComments
	comments := OrderedCollection new.!

initDates
	"adds default entry: 1.1.1901"
	dates := OrderedCollection new.!

initHistoryCollection
	historyCollection := OrderedCollection new.!

initialize
	"2.11.1998 all inits do not add default values anymore"

	self initDates.
	self initValues.
	self initChangedDates.
	self initAuthors.
	self initComments.!

initValues
	values := OrderedCollection new.!

insertValue: aValue dated: aDate author: aString comment: aCommentString beforeIndex: anIndex
	"adds data in position before specified index"
	self dates add: aDate asDays beforeIndex: anIndex.
	self values add: aValue beforeIndex: anIndex.
	self changedDates add: Date today asDays beforeIndex: anIndex.
	self authors add: aString beforeIndex: anIndex.
	self comments add: aString beforeIndex: anIndex.!

migrateHistoryCollection

	"migrate from historyCollection to bunch of collections. Remove duplicates"

	| date |
	date := nil.
	self initialize.
	self historyCollection reverseDo: [:array |
		date = (self dateFromArray: array)
			ifFalse: 
				[self 
					value: (self valueFromArray: array)
					dated: (self dateFromArray: array)
					author: ('')
					comment: ('').
				date := self dateFromArray: array] ].


"
Janko := History selectFromOdb select: [:h | h historyCollection size > 10].
(Janko at: 3) migrateHistoryCollection
Janko do: [:each | each migrateHistoryCollection].
Janko  select: [:h | h dates size > 3].
"!

newestDate

	"return a date of newest version of value"

	self dates isEmpty
		ifTrue: [^nil]
		ifFalse: 	[^Date fromDays: self dates last]

"History new newestDate"!

newestValue

	"return a newest version of value in historyCollection."

	self values isEmpty
		ifTrue: [^nil]
		ifFalse: 	[^self values last]
	

"History new newestValue"!

oldestDate

	"return a date of oldest version of value"

	self dates isEmpty
		ifTrue: [^nil]
		ifFalse: 	[^self dates first]
	

"History new oldestDate"!

oldestValue

	"return a oldest version of value"

	self values isEmpty
		ifTrue: [^nil]
		ifFalse: 	[^self values last]
	

"History new oldestValue"!

printString

	^('aHistory: ', self value printString)!

removeAllNils
	"REPARING BAD HISTORIES - remove all nil entries. Initialize if no more entries"

	2 to: self values size do: [:index |
		(self values at: index) isNil ifTrue: 
			[self removeIndex: index. ^self removeAllNils] ]!

removeDuplicateDates

	"maintenance - remove all duplicate entries with same dates. Live last one"

	| date index |
	self hasDuplicateDates ifTrue: 
		[date := 0. index := nil.
		1 to: self dates size do: 
			[:inx | 
				(self dates at: inx) = date ifTrue: [index := inx].
				date := self dates at: inx].
		index notNil 
			ifTrue: 
				[self removeIndex: index-1.
				self removeDuplicateDates].
		 ].!

removeIndex: aNumber
	"remove all entries on specified index"
	self dates removeIndex: aNumber.
	self values removeIndex: aNumber.
	self changedDates removeIndex: aNumber.
	self authors removeIndex: aNumber.
	self comments removeIndex: aNumber.!

removeLastNil
	"REPARING BAD HISTORIES - remove last entry if value nil. Initialize if no more entries"
	self values isEmpty 
		ifTrue: 
			[self initialize. self values removeLast; addLast: true.
			Transcript cr; show: 'init, true']
		ifFalse: [self values last isNil ifTrue: 
			[self removeIndex: (self dates size).
			self removeLastNil] ]!

timeFromArray: anArray

	"return a time from entries in history array"

	^Time fromSeconds: (anArray at: 3)!

value
	"get the curently valid value"

	^self valueDated: Date today

"History new value"!

value: aValue author: aString comment: aCommentString 
	"change a value of time series, which will be valid immediately - today. You should state author and a short comment about changes. see other methods for detailed explanation"

	self value: aValue
		dated: Date today
		author: aString
		comment: aCommentString!

value: aValue dated: aDate author: aString comment: aCommentString 
	""

	| index |

	index := self indexForDate: aDate. 
	index isNil   "older than any existing or first" 
		ifTrue: 
			[self 
				insertValue: aValue 
				dated: aDate
				author: aString 
				comment: aCommentString
				beforeIndex: 1.
			^self].

"Sprememba 18.11.1998 Sivec, prej 'index >= self dates  size'."
	index > self dates  size  "newer than any existing"
		ifTrue: 
			[self addValue: aValue dated: aDate author: aString comment: aCommentString. ^self].


	(index ~= 0 and: [(self dates at: index) = aDate asDays]) "already exists"
		ifTrue: 
			[self 
				changeValue: aValue 
				author: aString 
				comment: aCommentString 
				onIndex: index.
			^self].

		self    "insert new somewhere in the middle"
			insertValue: aValue 
			dated: aDate
			author: aString 
			comment: aCommentString
			beforeIndex: index+1.



"History new value: 1234 dated: Date today author: 'Janko' comment: 'test'"!

valueDated: aDate 
	"get the value from history, which was valid on specified date. Returns nil if aDate is older from 
	oldest entry in history"

	
	| index |
	index := self indexForDate: aDate.
	index = 0 ifTrue: [^nil].
	index = nil ifTrue: [^nil].
	^self values at: index.!

valueFromArray: anArray

	"return a value from entries in history array"

	^anArray at: 4!

values
	" a collection of values, each valid from date in dates at the same index"
	^values! !
!History categoriesFor: #activeFromArray:!private!private - history arrays! !
!History categoriesFor: #addValue:dated:author:comment:!private!private - adding-removing! !
!History categoriesFor: #arrayWithDate:time:value:active:!private!private - history arrays! !
!History categoriesFor: #authors!private!private - accessing! !
!History categoriesFor: #changedDates!private!private - accessing! !
!History categoriesFor: #changeValue:author:comment:onIndex:!private!private - adding-removing! !
!History categoriesFor: #comments!private!private - accessing! !
!History categoriesFor: #dateFromArray:!private!private - history arrays! !
!History categoriesFor: #dates!private!private - accessing! !
!History categoriesFor: #hasDuplicateDates!private!private - adding-removing! !
!History categoriesFor: #historyCollection!private!private - accessing! !
!History categoriesFor: #historyOfChanges!accessing!private! !
!History categoriesFor: #indexForDate:!private!private - accessing! !
!History categoriesFor: #initAuthors!initialize - release!private! !
!History categoriesFor: #initChangedDates!initialize - release!private! !
!History categoriesFor: #initComments!initialize - release!private! !
!History categoriesFor: #initDates!initialize - release!private! !
!History categoriesFor: #initHistoryCollection!private!private - accessing! !
!History categoriesFor: #initialize!initialize - release!private! !
!History categoriesFor: #initValues!initialize - release!private! !
!History categoriesFor: #insertValue:dated:author:comment:beforeIndex:!private!private - adding-removing! !
!History categoriesFor: #migrateHistoryCollection!private!private - history arrays! !
!History categoriesFor: #newestDate!private!private - accessing! !
!History categoriesFor: #newestValue!private!private - accessing! !
!History categoriesFor: #oldestDate!private!private - accessing! !
!History categoriesFor: #oldestValue!private!private - accessing! !
!History categoriesFor: #printString!printing!private! !
!History categoriesFor: #removeAllNils!private!private - adding-removing! !
!History categoriesFor: #removeDuplicateDates!private!private - adding-removing! !
!History categoriesFor: #removeIndex:!private!private - adding-removing! !
!History categoriesFor: #removeLastNil!private!private - adding-removing! !
!History categoriesFor: #timeFromArray:!private!private - history arrays! !
!History categoriesFor: #value!accessing!private! !
!History categoriesFor: #value:author:comment:!accessing!private! !
!History categoriesFor: #value:dated:author:comment:!accessing!private! !
!History categoriesFor: #valueDated:!accessing!private! !
!History categoriesFor: #valueFromArray:!private!private - history arrays! !
!History categoriesFor: #values!private!private - accessing! !

!History class methodsFor!

instancesAreForwarders
	"Gemstone"

	^false!

new
	^super new initialize!

tests
	"some test of histories. Use it directly from code with doIt/printIt/inspectIt "

	| history |
	history := History new.
	history value: 0 dated: (Date today ) author: '' comment: ''.
	history value: -2000 dated: (Date today - (365*100) -2) author: '' comment: ''.
	history value: -3 dated: (Date today -3) author: '' comment: ''.
	history value: -1 dated: (Date today -1) author: '' comment: ''.
	history value: 2 dated: (Date today +2) author: '' comment: ''.
	history value: 1 dated: (Date today +1) author: '' comment: ''.! !
!History class categoriesFor: #instancesAreForwarders!odb specific!private! !
!History class categoriesFor: #new!instance creation!private! !
!History class categoriesFor: #tests!examples!private! !

HtmlRender guid: (GUID fromString: '{7D0C67F3-6133-4192-8034-C5F580C481CA}')!
HtmlRender comment: 'For rendering formated text into HTML. Currently Wiki format supported (in WikRender subclass)

Thanks to WikiWorks authors for original code, which is adopted here!!
'!
!HtmlRender categoriesForClass!Unclassified! !
!HtmlRender methodsFor!

!!= anObject 
	self
		,= anObject;
		cr.
	^anObject!

,= anObject 
	^anObject sendOver: outputStream!

break
	self !!= '<br>'!

bulletList: aBlock 
	self startBulletList.
	aBlock value.
	self closeBulletList!

closeBulletList
	self !!= '</ul>'!

closeListItem
	self !!= '</li>'!

closeNumberList
	self !!= '</ol>'!

closeTableCell
	self !!= '</td>'!

cr
	outputStream cr.!

heading: aBlock 
	self heading: aBlock level: 2!

heading: aBlock level: anInteger 
	self
		,= '<h';
		,= anInteger;
		,= ' ><font face="Arial" >'.
	aBlock value.
	self
		,= '</font></h';
		,= anInteger;
		!!= '>'!

horizontalRule
	self !!= '<hr >'!

inlineImage: aBlock 
	self ,= '<img src="'.
	aBlock value.
	self !!= '" border="0" >'!

inputStream: aStream
	inputStream := aStream!

italicize: aBlock 
	self ,= '<i >'.
	aBlock value.
	self ,= '</i>'!

linkTo: urlBlock titled: titleBlock 
	self ,= '<a href="'.
	urlBlock value.
	self ,= '" >'.
	titleBlock value.
	self ,= '</a>'!

listItem: aBlock 
	self startListItem.
	aBlock value.
	self closeListItem!

outputStream: aStream
	outputStream := aStream!

paragraph
	self !!= '<p >'!

precise: aBlock 
	self ,= '<pre >'.
	aBlock value.
	self !!= '</pre>'!

space
	outputStream space!

startBulletList
	self ,= '<ul >'!

startListItem
	self ,= '<li >'!

startNumberList
	self ,= '<ol >'!

startTableCell: align 
	self ,= '<td align="'.
	self ,= align.
	self ,= '" >'!

startTableRow
	self startTableRow: 'center'!

startTableRow: align 
	self ,= '<tr >'.
	self startTableCell: align! !
!HtmlRender categoriesFor: #!=!public! !
!HtmlRender categoriesFor: #,=!private!streaming! !
!HtmlRender categoriesFor: #break!html-tags!private! !
!HtmlRender categoriesFor: #bulletList:!html-tags!private! !
!HtmlRender categoriesFor: #closeBulletList!html-tags!private! !
!HtmlRender categoriesFor: #closeListItem!html-tags!private! !
!HtmlRender categoriesFor: #closeNumberList!html-tags!private! !
!HtmlRender categoriesFor: #closeTableCell!html-tags!private! !
!HtmlRender categoriesFor: #cr!private!streaming! !
!HtmlRender categoriesFor: #heading:!html-tags!private! !
!HtmlRender categoriesFor: #heading:level:!html-tags!private! !
!HtmlRender categoriesFor: #horizontalRule!html-tags!private! !
!HtmlRender categoriesFor: #inlineImage:!html-tags!private! !
!HtmlRender categoriesFor: #inputStream:!initialize-release!private! !
!HtmlRender categoriesFor: #italicize:!html-tags!private! !
!HtmlRender categoriesFor: #linkTo:titled:!html-tags!private! !
!HtmlRender categoriesFor: #listItem:!html-tags!private! !
!HtmlRender categoriesFor: #outputStream:!initialize-release!private! !
!HtmlRender categoriesFor: #paragraph!html-tags!private! !
!HtmlRender categoriesFor: #precise:!html-tags!private! !
!HtmlRender categoriesFor: #space!private!streaming! !
!HtmlRender categoriesFor: #startBulletList!html-tags!private! !
!HtmlRender categoriesFor: #startListItem!html-tags!private! !
!HtmlRender categoriesFor: #startNumberList!html-tags!private! !
!HtmlRender categoriesFor: #startTableCell:!html-tags!private! !
!HtmlRender categoriesFor: #startTableRow!html-tags!private! !
!HtmlRender categoriesFor: #startTableRow:!html-tags!private! !

!HtmlRender class methodsFor!

from: aString
	"render aString in Wiki syntax and return Html string"
	| stream |
	stream := WriteStream on: String new.
	self from: aString into: stream.
	^stream contents!

from: aString into: aStream
	"only cr, convert cr-lf or lf to cr"
	| in out ch |
	in := aString readStream. out := String new writeStream.
	[in atEnd] whileFalse:
		[ch := in next. 
		ch = Character cr ifTrue: [in peek = Character lf ifTrue: [in next]]. "skip"
		ch = Character lf ifTrue: [ch := Character cr].
		out nextPut: ch].
	^self new
		inputStream: out contents readStream;
		outputStream: aStream;
		render.! !
!HtmlRender class categoriesFor: #from:!instance creation!private! !
!HtmlRender class categoriesFor: #from:into:!instance creation!private! !

Numberer guid: (GUID fromString: '{505F8757-4808-47EC-885E-08D8189489CB}')!
Numberer comment: 'Numberer is used to provide counters for things like invoice numbers

Instance Variables:
	counters	<Dictionary>	 counters for different purposes

'!
!Numberer categoriesForClass!Unclassified! !
!Numberer methodsFor!

counters
	counters isNil ifTrue: [self initCounters].
	^counters!

initCounters
	counters := Dictionary new!

nextCounter: aSymbol
	"get next number and increment this counter"
	^self counters at: aSymbol put: (self peekCounter: aSymbol)!

peekCounter: aSymbol
	"get next number but not increment it"
	(self counters includesKey: aSymbol) ifFalse: [self resetCounter: aSymbol].
	^(self counters at: aSymbol) + 1!

resetCounter: aSymbol
	"put counter to 0, peekCounter will then return 1"
	self counters at: aSymbol put: 0! !
!Numberer categoriesFor: #counters!private! !
!Numberer categoriesFor: #initCounters!initialize-release!private! !
!Numberer categoriesFor: #nextCounter:!accessing!private! !
!Numberer categoriesFor: #peekCounter:!accessing!private! !
!Numberer categoriesFor: #resetCounter:!accessing!private! !

RDBTable guid: (GUID fromString: '{B72971AD-466F-447A-A5B9-F1B9B29AA734}')!
RDBTable comment: ''!
!RDBTable categoriesForClass!Unclassified! !
!RDBTable methodsFor!

codepage
	"return a codepage of a external RDB source"
	codepage isNil ifTrue: [self codepage: self defaultCodepage].
	^codepage!

codepage: aSymbol
	" #cp1250 #cp852 #'7bit' #iso2 #czs    (slovenian codepages) "
	codepage := aSymbol.!

columns
	columns isNil ifTrue: [self initColumns].
	^columns!

columns: anObject
	columns := anObject!

convertRecords
	"convert db records to appropriate smalltalk format"
	| colType |
	1 to: columns size do: [:inx |
		colType := (self columns at: inx) at: 2.
		self records do: [:record |
			record 
				at: inx
				put: (self readFieldFrom: (record at: inx) odbcType: colType) ]
		].!

defaultCodepage
	"default codepage is #7bit "

	^#'7bit'!

environment
	environment isNil ifTrue: [self environment: ''].
	^environment!

environment: aString
	environment := aString!

getTableColumnsFrom: anODBCSession
	| answerStream |
	self initColumns.
	anODBCSession 
		getSQLColumns: nil
		tableOwner: nil
		tableName: self table 
		columnName: nil.
	answerStream := anODBCSession answer.
	self columns: (answerStream upToEnd
		collect: [:each | Array with: (each at: 4) with: (each at: 6)]).!

indexOfColumn: aString

	1 to: self columns size do: [:inx | 
		(self columns at: inx) first asLowercase = aString asLowercase ifTrue: [^inx] ].
	^0!

initColumns
	columns := OrderedCollection new.!

joinWithTable: aTableName myKey: aMyKey itsKey: anItsKey
	"return an outer join of both tables, columns combined"
	| secondTable myKeyInx myKeyPos newRecords itsKeyPos mergedRecord |
	secondTable := 	RDBTable newFromTable: aTableName
		environment: self environment
		username: self username
		password: self password
		codepage: self codepage.
	myKeyPos := self indexOfColumn: aMyKey.
	myKeyInx := Dictionary new.
	newRecords := OrderedCollection new.
	self records do: [:record |
		myKeyInx at: (record at: myKeyPos) put: record ].
	itsKeyPos := secondTable indexOfColumn: anItsKey.
	secondTable records do: [:record |
		(myKeyInx includesKey: (record at: itsKeyPos)) ifTrue:
			[mergedRecord := (myKeyInx at: (record at: itsKeyPos)).
			mergedRecord := mergedRecord, record.
			newRecords add: mergedRecord].
		].
	self records: newRecords.
	self columns: self columns, secondTable columns.!

password
	password isNil ifTrue: [self password: ''].
	^password!

password: aString
	password := aString!

readFieldFrom: aString odbcType: aTypeString

	"read one field from string, and convert to
	appropriate object. Do a codepage converting also. Return that object"

	aString isNil ifTrue: [^nil].
	aTypeString = 'Char' ifTrue:
		[self codepage = #cp1250 ifTrue: [^WebServer returnCP852FromCP1250String: aString].
		self codepage = #iso2 ifTrue: [^WebServer returnCP852FromISO2String: aString].
		self codepage = #csz   ifTrue: [^aString].  "you cannot convert!!"
		self codepage = #'7bit' ifTrue: [^WebServer returnCP852From7BitString: aString]. 
		].
	aTypeString = 'Date' ifTrue: [^aString]. "already converted"
	^aString!

readRecords
	| connection session answer |
	connection := ODBCConnection new.
	[connection
		environment: self environment;
		username: self username;
		password: self password;
		connect.
	session := connection getSession.
	self getTableColumnsFrom: session.
	session 
		prepare: 'select * from "', self table, '" ';
		bindOutput: (Array new: self columns size);
		execute.
	answer := session answer.
	self records: answer upToEnd.
	self convertRecords.
	] ensure: [session disconnect. connection disconnect].!

recordNr: aNumber column: aString 
	^(self records at: aNumber) at: (self indexOfColumn: aString)!

records
	"when aRDBTable is created from existing table, all records (rows in a table) are 
	converted and stored in this ordered collection. Fields in each record are stored in 
	another ordered collection as objects of appropriate class (texts as Strings, 
	numbers as Integers or Floats, dates as Dates)"

	records isNil ifTrue: [self records:OrderedCollection new].
	^records!

records: aCollection
	records := aCollection.!

table
	table isNil ifTrue: [self table: ''].
	^table!

table: aString
	table := aString!

typeOfColumn: aString

	1 to: self columns size do: [:inx | 
		(self columns at: inx) first asLowercase = aString asLowercase 
			ifTrue: [^(self columns at: inx) at: 2] ].
	^nil!

username
	username isNil ifTrue: [self username: ''].
	^username!

username: aString
	username := aString! !
!RDBTable categoriesFor: #codepage!accessing!private! !
!RDBTable categoriesFor: #codepage:!accessing!private! !
!RDBTable categoriesFor: #columns!accessing!private! !
!RDBTable categoriesFor: #columns:!private! !
!RDBTable categoriesFor: #convertRecords!private! !
!RDBTable categoriesFor: #defaultCodepage!accessing!private! !
!RDBTable categoriesFor: #environment!accessing!private! !
!RDBTable categoriesFor: #environment:!accessing!private! !
!RDBTable categoriesFor: #getTableColumnsFrom:!private!table reading! !
!RDBTable categoriesFor: #indexOfColumn:!private! !
!RDBTable categoriesFor: #initColumns!initialize - release!private! !
!RDBTable categoriesFor: #joinWithTable:myKey:itsKey:!private!table join! !
!RDBTable categoriesFor: #password!accessing!private! !
!RDBTable categoriesFor: #password:!accessing!private! !
!RDBTable categoriesFor: #readFieldFrom:odbcType:!private! !
!RDBTable categoriesFor: #readRecords!private!table reading! !
!RDBTable categoriesFor: #recordNr:column:!private!table accessing! !
!RDBTable categoriesFor: #records!accessing!private! !
!RDBTable categoriesFor: #records:!private! !
!RDBTable categoriesFor: #table!accessing!private! !
!RDBTable categoriesFor: #table:!accessing!private! !
!RDBTable categoriesFor: #typeOfColumn:!private! !
!RDBTable categoriesFor: #username!accessing!private! !
!RDBTable categoriesFor: #username:!accessing!private! !

!RDBTable class methodsFor!

fromDemoTable
	"RDBTable fromDemoTable"
	^self newFromTable: 'ks801art'
		environment: 'skladisca'
		username:''
		password: ''
		codepage: #'7bit'.!

joinTwoTables
	"RDBTable joinTwoTables"
	| first merged |
	first := self newFromTable: 'ks801art'
		environment: 'skladisca'
		username:''
		password: ''
		codepage: #'7bit'.
	merged := first joinWithTable: 'ks810kar' myKey: 'SIFRA801' itsKey: 'SIFRA801'.
	^merged.!

newFromTable: aTableString environment: anEnvString username: anUserString password: aPswString

	^super new
		table: aTableString;
		environment: anEnvString;
		username: anUserString;
		password: aPswString;
		readRecords.!

newFromTable: aTableString environment: anEnvString username: anUserString password: aPswString codepage: aSymbol

	^super new
		table: aTableString;
		environment: anEnvString;
		username: anUserString;
		password: aPswString;
		codepage: aSymbol;
		readRecords.! !
!RDBTable class categoriesFor: #fromDemoTable!examples!private! !
!RDBTable class categoriesFor: #joinTwoTables!examples!private! !
!RDBTable class categoriesFor: #newFromTable:environment:username:password:!instance creation!private! !
!RDBTable class categoriesFor: #newFromTable:environment:username:password:codepage:!instance creation!private! !

VersionedObject guid: (GUID fromString: '{37C93A13-1015-4932-A4EF-E267BCA0826D}')!
VersionedObject comment: ''!
!VersionedObject categoriesForClass!Unclassified! !
!VersionedObject methodsFor!

allVersions
	^self version allVersionSpecs collect: [:each | each object]!

asNewVersion
	"return a new version of that object with all its current contents"
	| new |
	new := self class new.
	new version: (VersionSpec newFromParent: self for: new).
	self copyContentsTo: new.
	^new!

copyContentsTo: anObject
	"override in subclases to copy contents to a new object"!

currentVersion
	"find a current version of object in a version chain"
	^self version currentVersionSpec object!

initVersion
	self version: (VersionSpec firstFor: self)!

isCurrentVersion
	^self version isCurrent!

isNewestVersion
	^self version isNewest!

isOldestVersion
	^self version isOldest!

isOnlyVersion
	^self version isOldest & self version isNewest!

isVersionedObject
	^true!

newerVersions
	^self version newerVersionSpecs collect: [:each | each object]!

newestVersion
	self isNewestVersion ifTrue: [^self].
	^self newerVersions last!

nextVersion
	"next version of an object in version chain, if any"
	^self version next!

olderVersions
	^self version olderVersionSpecs collect: [:each | each object]!

oldestVersion
	self isOldestVersion ifTrue: [^self].
	^self olderVersions first!

parentVersion
	"older version of an object in version chain, if any. It is a parent of that object, 
	because it is derived from it"
	^self version parent!

setCurrentVersion
	"set this object as current version, which has always the same identity "
	| other |
	self isCurrentVersion ifTrue: [^nil].
	other := self currentVersion.
	self swapIdentityWith: other.
	^other version setCurrent "because other is now me!! "!

swapIdentityWith: anObject
	"carefully adjust object references (object, parent, next) in version specs too!!"
	|  o1 o2 s1Spec s2Spec |
	o1 := self. o2 := anObject.  s1Spec := o1 version. s2Spec := o2 version.
	o1 become: o2.
	s1Spec object: o2. s2Spec object: o1.
	s1Spec isNewest ifFalse:
		[s1Spec next == o2 ifTrue: [s1Spec next: o1] ifFalse: [s1Spec next version parent: o2] ].
	s1Spec isOldest ifFalse:
		[s1Spec parent == o2 ifTrue: [s1Spec parent: o1] ifFalse: [s1Spec parent version next: o2]].
	s2Spec isNewest ifFalse:
		[s2Spec next == o1 ifTrue: [s2Spec next: o2] ifFalse: [s2Spec next version parent: o1] ].
	s2Spec isOldest ifFalse:
		[s2Spec parent == o1 ifTrue: [s2Spec parent: o2] ifFalse: [s2Spec parent version next: o1]].!

version
	version isNil ifTrue: [self initVersion].
	^version!

version: aVersionSpec
	version := aVersionSpec!

versionNumber
	"version number, integer by default, but it can be any string"
	^self version number!

versionNumber: aString
	"set version number other than default"
	^self version number: aString!

versionWithNumber: aString
	"find version with that number"
	| spec |
	spec := self version versionSpecWithNumber: aString.
	^spec notNil ifTrue: [spec object] ifFalse: [nil]! !
!VersionedObject categoriesFor: #allVersions!accessing-versions!private! !
!VersionedObject categoriesFor: #asNewVersion!copying!private! !
!VersionedObject categoriesFor: #copyContentsTo:!copying!private! !
!VersionedObject categoriesFor: #currentVersion!accessing-current!private! !
!VersionedObject categoriesFor: #initVersion!initialize-release!private! !
!VersionedObject categoriesFor: #isCurrentVersion!private!testing! !
!VersionedObject categoriesFor: #isNewestVersion!private!testing! !
!VersionedObject categoriesFor: #isOldestVersion!private!testing! !
!VersionedObject categoriesFor: #isOnlyVersion!private!testing! !
!VersionedObject categoriesFor: #isVersionedObject!private!testing! !
!VersionedObject categoriesFor: #newerVersions!accessing-versions!private! !
!VersionedObject categoriesFor: #newestVersion!accessing-versions!private! !
!VersionedObject categoriesFor: #nextVersion!accessing-versions!private! !
!VersionedObject categoriesFor: #olderVersions!accessing-versions!private! !
!VersionedObject categoriesFor: #oldestVersion!accessing-versions!private! !
!VersionedObject categoriesFor: #parentVersion!accessing-versions!private! !
!VersionedObject categoriesFor: #setCurrentVersion!accessing-current!private! !
!VersionedObject categoriesFor: #swapIdentityWith:!private! !
!VersionedObject categoriesFor: #version!private! !
!VersionedObject categoriesFor: #version:!private! !
!VersionedObject categoriesFor: #versionNumber!accessing!private! !
!VersionedObject categoriesFor: #versionNumber:!accessing!private! !
!VersionedObject categoriesFor: #versionWithNumber:!accessing!private! !

VersionSpec guid: (GUID fromString: '{16826841-5CB5-4B56-A16F-6FA371570D23}')!
VersionSpec comment: 'VersionSpec defines a versioned object by its number and position in version chain.

Instance Variables:
	number	<String>	 number of that version. Integer by default, but it can be any string
	current	<Boolean> true, if this version is current, that is, most important, released, etc.
	parent	<Object> parent, that is, previous version of that object, nil if noone
	next		<Object> next version of that object, nil if noone

'!
!VersionSpec categoriesForClass!Unclassified! !
!VersionSpec methodsFor!

allVersionSpecs
	^self olderVersionSpecs, (Array with: self), self newerVersionSpecs!

clearCurrent
	current := false!

current
	"this version current one? Current version object have a direct url, without 'version=' in query part"
	^current!

current: aBoolean
	current := aBoolean!

currentVersionSpec
	"find a version spec of current object in a chain"
	self isCurrent ifTrue: [^self].
	^self olderVersionSpecs detect: [:each | each isCurrent] ifNone: 
		[^self newerVersionSpecs detect: [:each | each isCurrent] 
			ifNone: [self error: 'no current version!!'] ].!

isCurrent
	^self current!

isNewest
	^self next isNil!

isOldest
	^self parent isNil!

newerVersionSpecs
	"return all version specs of that object, newer than this one"
	self isNewest ifTrue: [^#()].
	^OrderedCollection new 
		add: self next version; addAll: self next version newerVersionSpecs;
		yourself!

next
	"next version of an object in version chain, if any"
	^next!

next: anObject
	next := anObject!

number
	"version number, integer by default, but it can be any string"
	^number!

number: aString
	number := aString!

object
	"object for which is this version spec"
	^object!

object: anObject
	object := anObject!

olderVersionSpecs
	"return all version specs of that object, older than this one"
	self isOldest ifTrue: [^#()].
	^OrderedCollection new 
		addAll: self parent version olderVersionSpecs; add: self parent version;
		yourself!

otherVersionSpecs
	"older and newer versions, if any"
	^self olderVersionSpecs, self newerVersionSpecs!

parent
	"older version of an object in version chain, if any. It is a parent of that object, 
	because it is derived from it"
	^parent!

parent: anObject
	parent := anObject!

printString
	^'aVersionSpec version: ', self number!

setCurrent
	self current: true.
	self otherVersionSpecs do: [:each | each clearCurrent].!

setDefaultNumber
	self isOldest 
		ifTrue: [self number: '1'] 
		ifFalse: [self setIncrementedNumberFromParent]!

setIncrementedNumberFromParent
	"for now, later it should increment last number in string"
	self number: (self parent version number asInteger + 1) printString!

versionSpecWithNumber: aString
	"find spec  with that version number"
	self number = aString ifTrue: [^self].
	^self olderVersionSpecs detect: [:each | each number = aString] ifNone: 
		[^self newerVersionSpecs detect: [:each | each number = aString] ifNone: [nil] ].! !
!VersionSpec categoriesFor: #allVersionSpecs!accessing!private! !
!VersionSpec categoriesFor: #clearCurrent!private! !
!VersionSpec categoriesFor: #current!private! !
!VersionSpec categoriesFor: #current:!private! !
!VersionSpec categoriesFor: #currentVersionSpec!accessing!private! !
!VersionSpec categoriesFor: #isCurrent!private!testing! !
!VersionSpec categoriesFor: #isNewest!private!testing! !
!VersionSpec categoriesFor: #isOldest!private!testing! !
!VersionSpec categoriesFor: #newerVersionSpecs!accessing!private! !
!VersionSpec categoriesFor: #next!accessing!private! !
!VersionSpec categoriesFor: #next:!private! !
!VersionSpec categoriesFor: #number!accessing!private! !
!VersionSpec categoriesFor: #number:!accessing!private! !
!VersionSpec categoriesFor: #object!accessing!private! !
!VersionSpec categoriesFor: #object:!private! !
!VersionSpec categoriesFor: #olderVersionSpecs!accessing!private! !
!VersionSpec categoriesFor: #otherVersionSpecs!accessing!private! !
!VersionSpec categoriesFor: #parent!accessing!private! !
!VersionSpec categoriesFor: #parent:!private! !
!VersionSpec categoriesFor: #printString!private! !
!VersionSpec categoriesFor: #setCurrent!accessing!private! !
!VersionSpec categoriesFor: #setDefaultNumber!initalize-release!private! !
!VersionSpec categoriesFor: #setIncrementedNumberFromParent!initalize-release!private! !
!VersionSpec categoriesFor: #versionSpecWithNumber:!accessing!private! !

!VersionSpec class methodsFor!

firstFor: anObject
	"for a first version of an object"
	^super new
		object: anObject;
		setDefaultNumber;
		setCurrent!

new
	^self shouldNotImplement!

newFromParent: anOldObject for: aNewObject
	| newSpec |
	newSpec := super new
		object: aNewObject;
		parent: anOldObject;
		setIncrementedNumberFromParent;
		clearCurrent.
	aNewObject version: newSpec.
	anOldObject version next: aNewObject.
	^newSpec! !
!VersionSpec class categoriesFor: #firstFor:!instance creation!private! !
!VersionSpec class categoriesFor: #new!private! !
!VersionSpec class categoriesFor: #newFromParent:for:!instance creation!private! !

WikiLink guid: (GUID fromString: '{F7DBD940-1240-4FDC-9A2A-98B76C22A857}')!
WikiLink comment: 'From WikiWorks, Thanks to authors for such a wonderfull job!!

Instance Variables:
	address	<SequenceableCollection>	description of address
	fragment	<Object>	description of fragment
	isMethod	<Boolean>	description of isMethod
	name	<Object>	description of name
	siblingReference	<Object >	description of siblingReference

'!
!WikiLink categoriesForClass!Unclassified! !
!WikiLink methodsFor!

address
	^address!

contents: aString 
	| realString rs isAnonymous |
	realString := aString trimBlanks. rs := realString readStream.
	(rs contents containsSubstring: '&gt;') "named char for > "
		ifTrue: [name := (rs upToAll: '&gt;') trimBlanks. rs skip: 4] 
		ifFalse: [name := (rs upTo: $> escaper: $\) trimBlanks].
	isMethod := (rs peekForAll: '>#') | (rs peekForAll: '&gt;#').
	isMethod ifTrue: [address := rs upToEnd trimBlanks asSymbol. ^self].
	isAnonymous := rs atEnd.
	address := isAnonymous ifTrue: [name] ifFalse: [rs upToEnd trimBlanks].
	isAnonymous ifTrue: [name := nil].
	self isExternalLink ifTrue: [^self].
	rs := address readStream. address := (rs upTo: $!! escaper: $\) trimBlanks.
	rs atEnd ifFalse: 	[siblingReference := address. 	address := rs upToEnd trimBlanks]!

externalLinkPrefixes
	^#('http://*' 'https://*' 'mailto:*' 'file:/*' 'ftp://*' 'news:*' 'nntp://*' 'telnet://*' 'prospero://*' 'gopher://*' 'wais://*')!

fragment
	^fragment!

fragmentize
	| rs |
	rs := address readStream.
	address := rs upTo: $# escaper: $\.
	rs atEnd ifFalse: [fragment := rs upToEnd]!

hasFragment
	^fragment notNil!

imageLinkSuffixes
	^#('*.gif' '*.jpeg' '*.jpg' '*.jpe')!

initialize
	isMethod := false!

isAnonymous
	^name isNil!

isExternalLink
	^self externalLinkPrefixes contains: [:each | each match: address]!

isImage
	^self imageLinkSuffixes contains: [:each | each match: address]!

isMethod
	^isMethod!

name
	| externalLinkPrefix |
	self isAnonymous ifFalse: [^name].
	externalLinkPrefix := self externalLinkPrefixes 
				detect: [:each | each match: address]
				ifNone: [^address].
	^address copyFrom: externalLinkPrefix size to: address size!

siblingReference
	^siblingReference! !
!WikiLink categoriesFor: #address!accessing!private! !
!WikiLink categoriesFor: #contents:!initialize-release!private! !
!WikiLink categoriesFor: #externalLinkPrefixes!constants!private! !
!WikiLink categoriesFor: #fragment!accessing!private! !
!WikiLink categoriesFor: #fragmentize!initialize-release!private! !
!WikiLink categoriesFor: #hasFragment!private!testing! !
!WikiLink categoriesFor: #imageLinkSuffixes!constants!private! !
!WikiLink categoriesFor: #initialize!initialize-release!private! !
!WikiLink categoriesFor: #isAnonymous!private!testing! !
!WikiLink categoriesFor: #isExternalLink!private!testing! !
!WikiLink categoriesFor: #isImage!private!testing! !
!WikiLink categoriesFor: #isMethod!private!testing! !
!WikiLink categoriesFor: #name!accessing!private! !
!WikiLink categoriesFor: #siblingReference!accessing!private! !

!WikiLink class methodsFor!

new
	^super new initialize! !
!WikiLink class categoriesFor: #new!instance creation!private! !

WikiRender guid: (GUID fromString: '{6673F77D-30CE-4100-B568-896A42860C55}')!
WikiRender comment: 'Renders input in Wiki syntax to Html output.

Thanks to WikiWorks authors for original code, which is adopted here!!

Instance Variables:
	bulletLevel	<Number>
	currentChar	<Char>	
	headingLevel	<Number>
	inTable	<Boolean>	
	lastChar	<Boolean>	
	numberLevel	<Number>

'!
!WikiRender categoriesForClass!Unclassified! !
!WikiRender methodsFor!

addCurrentChar
	self ,= currentChar!

atLineStart
	^lastChar == Character cr!

closeBullets
	self closeListItem.
	inputStream peek = $* ifFalse: 
		[bulletLevel timesRepeat: [self closeBulletList].
		self resetBullets]!

closeHeading
	self
		,= '</h';
		,= headingLevel printString;
		!!= '>'.
	self resetHeading!

closeNumbers
	self closeListItem.
	inputStream peek = $# ifFalse: 
		[numberLevel timesRepeat: [self closeNumberList].
		self resetNumbers]!

closeTableRow
	self closeTableCell.
	self !!= '</tr>'.
	((inputStream peekForAll: '||') 
		or: [(inputStream peekForAll: '|{') or: [inputStream peekForAll: '|}']]) 
			ifTrue: 
				[inputStream skip: -2.
				^self].
	self !!= '</table>'.
	self notInTable!

getNextChar
	lastChar := currentChar.
	currentChar := inputStream next!

inBold
	^inBold!

inBullets
	^bulletLevel > 0!

inExceptLinksMode
	"parse all but leave links in square brackets intact"
	^self mode == #exceptLinks!

inFullMode
	"full wiki syntax parsing - default"
	^self mode == #full!

inHeading
	^headingLevel > 0!

inLinksOnlyMode
	"only links in square brackets parsing"
	^self mode == #linksOnly!

inNumbers
	^numberLevel > 0!

inTable
	^inTable!

isInBold
	inBold := true!

isInTable
	inTable := true!

mode
	mode isNil ifTrue: [self setFullMode].
	^mode!

mode: aSymbol
	mode := aSymbol!

notInBold
	inBold := false!

notInTable
	inTable := false!

processAsterix
	| currentLevel |
	self atLineStart ifFalse: 
		[self inBold ifTrue: [self ,= '</b>'. ^self notInBold] ifFalse: [self ,= '<b>'. ^self isInBold]].
	self inBullets ifTrue: [self closeListItem].
	currentLevel := 1.
	[inputStream peekFor: $*] whileTrue: [currentLevel := currentLevel + 1].
	bulletLevel - currentLevel timesRepeat: [self closeBulletList].
	currentLevel - bulletLevel timesRepeat: [self startBulletList].
	self startListItem.
	bulletLevel := currentLevel!

processBang
	self atLineStart 
		ifTrue: [self processHeadingLevel]
		ifFalse: [self addCurrentChar]!

processCR
	self inHeading ifTrue: [^self closeHeading].
	self inTable ifTrue: [^self closeTableRow].
"	self atLineStart ifFalse: [^self space]. " "break always!! "
	self inBullets ifTrue: [^self closeBullets].
	self inNumbers ifTrue: [^self closeNumbers].
	self break!

processCurrentChar
	(self inFullMode | self inExceptLinksMode ) ifTrue:
		[currentChar == $\ ifTrue: [^self processEscape].
		currentChar == Character space ifTrue: [^self processSpace].
		currentChar == Character tab ifTrue: [^self processSpace].
		currentChar == Character cr ifTrue: [^self processCR].
		currentChar == $< ifTrue: [^self processLeftAngle].
		currentChar == $* ifTrue: [^self processAsterix].
		currentChar == $# ifTrue: [^self processPound].
		currentChar == $~ ifTrue: [^self processTilde].
		currentChar == $- ifTrue: [^self processDash].
		currentChar == $!! ifTrue: [^self processBang].
		currentChar == $| ifTrue: [^self processPipe] ].
	self inExceptLinksMode not ifTrue:
		[currentChar == $[ ifTrue: [^self processLeftBracket] ]. 

	self addCurrentChar!

processDash
	(self atLineStart and: [inputStream peekForAll: '---']) 
		ifFalse: [^self addCurrentChar].
	inputStream skipThrough: Character cr.
	currentChar := Character cr.
	self horizontalRule!

processEscape
	self getNextChar.
	self addCurrentChar!

processHeadingLevel
	headingLevel := headingLevel + 1.
	(inputStream peekFor: $!!) ifTrue: [^self processHeadingLevel].
	self
		,= '<h';
		,= headingLevel printString;
		,= '>'!

processLeftAngle
	self addCurrentChar.
	(inputStream insensitivePeekForAll: 'PRE') ifFalse: [^self].
	self ,= 'pre'.
	
	[inputStream atEnd or: 
			[| closeTag |
			closeTag := inputStream through: $>.
			self ,= closeTag.
			closeTag sameAs: '/pre>']] 
			whileFalse: [self ,= (inputStream through: $<)].
	currentChar := $>!

processLeftBracket
	| link url exist urlTitle |
	(inputStream peekFor: $[) ifTrue: [^self addCurrentChar].
	link := WikiLink new contents: (inputStream upTo: $] escaper: $\).
"	link isImage ifTrue: 
		[^self inlineImage: [link isExternalLink ifFalse: [self fileServerURL: targetHandler].
		self ,= link address]]. "
	link isExternalLink ifTrue: [^self linkTo: [self ,= link address] titled: [self ,= link name]].
	url := self urlFor: link address. exist := self exist: link address.
	(self allowed: link address) ifFalse: 
		[^self ,= ('<span style={color:lightgrey}>', link name, '</span>')].
	urlTitle := (exist ifFalse: ['<i>'] ifTrue: ['']), link name, (exist ifFalse: ['</i>'] ifTrue: ['']).
	url notNil ifTrue: [^self linkTo: [self ,= url] titled: [self ,=urlTitle] ].
	^self ,= link name!

processMethod: link 
	| class className selector |
	className := link name.
	class := [Compiler evaluate: className] on: Error
				do: [:ex | ex return: nil].
	selector := link address.
	(class isBehavior and: [class canUnderstand: selector]) 
		ifTrue: [^self processMethodSelector: selector ofClass: class].
	self italicise: 
			[self ,= className.
			self ,= '>>#'.
			self ,= selector]!

processMethodSelector: selector ofClass: class 
	| source realClass |
	realClass := (class includesSelector: selector) 
				ifTrue: [class]
				ifFalse: [class whichClassIncludesSelector: selector].
	source := realClass sourceCodeAt: selector.
	self precise: 
			[self ,= class.
			class == realClass 
				ifFalse: 
					[self ,= $(.
					self ,= realClass.
					self ,= $)].
			self ,= '>>#'.
			self ,= source]!

processPipe
	| align |
	(inputStream peekFor: $|) ifTrue: [align := 'center'].
	(inputStream peekFor: ${) ifTrue: [align := 'left'].
	(inputStream peekFor: $}) ifTrue: [align := 'right'].
	align ifNil: [^self addCurrentChar].
	self atLineStart 
		ifFalse: 
			[^self inTable 
				ifTrue: 
					[self closeTableCell.
					self startTableCell: align]
				ifFalse: [self ,= '||']].
	self inTable 
		ifFalse: [self !!= '<table class="wikiTable">'].
	self startTableRow: align.
	self isInTable!

processPound
	| currentLevel |
	self atLineStart ifFalse: [^self addCurrentChar].
	self inNumbers ifTrue: [self closeListItem].
	currentLevel := 1.
	[inputStream peekFor: $#] whileTrue: [currentLevel := currentLevel + 1].
	numberLevel - currentLevel timesRepeat: [self closeNumberList].
	currentLevel - numberLevel timesRepeat: [self startNumberList].
	self startListItem.
	numberLevel := currentLevel!

processSpace
	self atLineStart ifFalse: [lastChar := currentChar. ^self space].
	self getNextChar.
	lastChar := Character space.
"	lastChar := Character cr. "
	self processCurrentChar!

processTilde
	self atLineStart ifTrue: [self break] ifFalse: [self addCurrentChar]!

render
	"convert Wiki text in inputStream into Html outputStream"
	self resetParsingStates.
	[inputStream atEnd] whileFalse: 
		[self getNextChar. self processCurrentChar].
	lastChar := currentChar := Character cr.
	self processCurrentChar.!

resetBullets
	bulletLevel := 0!

resetHeading
	headingLevel := 0!

resetNumbers
	numberLevel := 0!

resetParsingStates
	currentChar := Character cr.
	self resetHeading.
	self resetBullets.
	self resetNumbers.
	self notInTable.
	self notInBold.!

setExceptLinksMode
	"parse all but leave links in square brackets intact"
	^self mode: #exceptLinks!

setFullMode
	"full wiki syntax parsing - default"
	self mode: #full!

setLinksOnlyMode
	"only links in square brackets parsing"
	self mode: #linksOnly!

urlFor: aString
	"find an url for an object with a specificied name (eg. a document with that name)"
	"override for your project!!"
	^nil! !
!WikiRender categoriesFor: #addCurrentChar!parsing!private! !
!WikiRender categoriesFor: #atLineStart!parsing states!private! !
!WikiRender categoriesFor: #closeBullets!parsing!private! !
!WikiRender categoriesFor: #closeHeading!parsing!private! !
!WikiRender categoriesFor: #closeNumbers!parsing!private! !
!WikiRender categoriesFor: #closeTableRow!parsing!private! !
!WikiRender categoriesFor: #getNextChar!parsing!private! !
!WikiRender categoriesFor: #inBold!parsing states!private! !
!WikiRender categoriesFor: #inBullets!parsing states!private! !
!WikiRender categoriesFor: #inExceptLinksMode!accessing-mode!private! !
!WikiRender categoriesFor: #inFullMode!accessing-mode!private! !
!WikiRender categoriesFor: #inHeading!parsing states!private! !
!WikiRender categoriesFor: #inLinksOnlyMode!accessing-mode!private! !
!WikiRender categoriesFor: #inNumbers!parsing states!private! !
!WikiRender categoriesFor: #inTable!parsing states!private! !
!WikiRender categoriesFor: #isInBold!parsing states!private! !
!WikiRender categoriesFor: #isInTable!parsing states!private! !
!WikiRender categoriesFor: #mode!private! !
!WikiRender categoriesFor: #mode:!private! !
!WikiRender categoriesFor: #notInBold!parsing states!private! !
!WikiRender categoriesFor: #notInTable!parsing states!private! !
!WikiRender categoriesFor: #processAsterix!parsing!private! !
!WikiRender categoriesFor: #processBang!parsing!private! !
!WikiRender categoriesFor: #processCR!parsing!private! !
!WikiRender categoriesFor: #processCurrentChar!parsing!private! !
!WikiRender categoriesFor: #processDash!parsing!private! !
!WikiRender categoriesFor: #processEscape!parsing!private! !
!WikiRender categoriesFor: #processHeadingLevel!parsing!private! !
!WikiRender categoriesFor: #processLeftAngle!parsing!private! !
!WikiRender categoriesFor: #processLeftBracket!parsing!private! !
!WikiRender categoriesFor: #processMethod:!parsing!private! !
!WikiRender categoriesFor: #processMethodSelector:ofClass:!parsing!private! !
!WikiRender categoriesFor: #processPipe!parsing!private! !
!WikiRender categoriesFor: #processPound!parsing!private! !
!WikiRender categoriesFor: #processSpace!parsing!private! !
!WikiRender categoriesFor: #processTilde!parsing!private! !
!WikiRender categoriesFor: #render!private!rendering! !
!WikiRender categoriesFor: #resetBullets!parsing states!private! !
!WikiRender categoriesFor: #resetHeading!parsing states!private! !
!WikiRender categoriesFor: #resetNumbers!parsing states!private! !
!WikiRender categoriesFor: #resetParsingStates!parsing states!private! !
!WikiRender categoriesFor: #setExceptLinksMode!accessing-mode!private! !
!WikiRender categoriesFor: #setFullMode!accessing-mode!private! !
!WikiRender categoriesFor: #setLinksOnlyMode!accessing-mode!private! !
!WikiRender categoriesFor: #urlFor:!private! !

!WikiRender class methodsFor!

example1
	"WikiRender example1"
	^WikiRender from: 'aaa bbb ccc ddd eee'!

exampleBullets
	"WikiRender exampleBullets"
	^WikiRender from: '
*bullet
*bullet
**deeper
**deeper
***even deeper
*bullet
*bullet
'!

exampleHeadings
	"WikiRender exampleHeadings"
	^WikiRender from: '
!!heading 1
!!!!heading 2
!!!!!!heading 3
!!!!!!!!heading 4
!!!!!!!!!!heading 5
!!!!!!!!!!!!heading 6 wrong!!
'!

exampleLineBreaks
	"WikiRender exampleLineBreaks"
	^WikiRender from: '
aaa bbb ccc ddd eee


ccc ddd

fff ggg
fff
ggg'!

exampleNumberedList
	"WikiRender exampleNumberedList"
	^WikiRender from: '
#numbered
##deeper
###even deeper
#numbered
#numbered
'!

exampleTables
	"WikiRender exampleTables"
	^WikiRender from: '
|| column1 || column2 || column3
|{ left |{ left |{ left
|} right |} right 
|| column1 || column2 || column3 || column4
'!

exceptLinksFrom: aString
	"render aString in Wiki syntax (leave links in square brackets intact) and return Html string"
	| stream |
	stream := WriteStream on: String new.
	self exceptLinksFrom: aString into: stream.
	^stream contents!

exceptLinksFrom: aString into: aStream
	self new
		inputStream: (aString copyWithout: Character lf) readStream;
		outputStream: aStream;
		setExceptLinksMode;
		render.!

linksOnlyFrom: aString
	"render aString in Wiki syntax (links in square brackets only) and return Html string"
	| stream |
	stream := WriteStream on: String new.
	self linksOnlyFrom: aString into: stream.
	^stream contents!

linksOnlyFrom: aString into: aStream
	self new
		inputStream: (aString copyWithout: Character lf) readStream;
		outputStream: aStream;
		setLinksOnlyMode;
		render.! !
!WikiRender class categoriesFor: #example1!examples!private! !
!WikiRender class categoriesFor: #exampleBullets!examples!private! !
!WikiRender class categoriesFor: #exampleHeadings!examples!private! !
!WikiRender class categoriesFor: #exampleLineBreaks!examples!private! !
!WikiRender class categoriesFor: #exampleNumberedList!examples!private! !
!WikiRender class categoriesFor: #exampleTables!examples!private! !
!WikiRender class categoriesFor: #exceptLinksFrom:!instance creation!private! !
!WikiRender class categoriesFor: #exceptLinksFrom:into:!instance creation!private! !
!WikiRender class categoriesFor: #linksOnlyFrom:!instance creation!private! !
!WikiRender class categoriesFor: #linksOnlyFrom:into:!instance creation!private! !

"Binary Globals"!

